# 
# Magisk init script service.sh for the Magisk Module
#
# History
#   31.10.2024 /bs
#     initial release
#     
#

MODPATH="$(dirname $0)"

MODULE_NAME="$( grep "^id=" $MODPATH/module.prop  | cut -f2 -d "=" )"
[ "${MODULE_NAME}"x = ""x ] && MODULE_NAME="unknown_magisk_module"

# -----------------------------------------------------------------------------
#
if [ 0 = 1 -o -r /data/local/tmp/debug ] ; then
  LOGFILE="/data/local/tmp/${MODULE_NAME}_service.log"

#  echo "Writing all messages to the log file ${LOGFILE}"

  exec 1>"${LOGFILE}" 2>&1
  set -x
fi

# allow tmux for non-root user
#
magiskpolicy --live "allow shell shell_data_file sock_file { create getattr setattr write unlink }"  
magiskpolicy --live "allow shell devpts chr_file { read write open }"

