# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

package Config;
use strict;
use warnings;
use vars '%Config';

sub bincompat_options {
    return split ' ', (Internals::V())[0];
}

sub non_bincompat_options {
    return split ' ', (Internals::V())[1];
}

sub compile_date {
    return (Internals::V())[2]
}

sub local_patches {
    my (undef, undef, undef, @patches) = Internals::V();
    return @patches;
}

sub _V {
    die "Perl lib was built for 'android' but is being run on '$^O'"
        unless "android" eq $^O;

    my ($bincompat, $non_bincompat, $date, @patches) = Internals::V();

    my $opts = join ' ', sort split ' ', "$bincompat $non_bincompat";

    # wrap at 76 columns.

    $opts =~ s/(?=.{53})(.{1,53}) /$1\n                        /mg;

    print Config::myconfig();
    print "\nCharacteristics of this binary (from libperl): \n";

    print "  Compile-time options: $opts\n";

    if (@patches) {
        print "  Locally applied patches:\n";
        print "\t$_\n" foreach @patches;
    }

    print "  Built under android\n";

    print "  $date\n" if defined $date;

    my @env = map { "$_=\"$ENV{$_}\"" } sort grep {/^PERL/} keys %ENV;

    if (@env) {
        print "  \%ENV:\n";
        print "    $_\n" foreach @env;
    }
    print "  \@INC:\n";
    print "    $_\n" foreach @INC;
}

sub header_files {
    return qw(EXTERN.h INTERN.h XSUB.h av.h config.h cop.h cv.h
              dosish.h embed.h embedvar.h form.h gv.h handy.h hv.h hv_func.h
              intrpvar.h iperlsys.h keywords.h mg.h nostdio.h op.h opcode.h
              pad.h parser.h patchlevel.h perl.h perlio.h perliol.h perlsdio.h
              perlvars.h perly.h pp.h pp_proto.h proto.h regcomp.h regexp.h
              regnodes.h scope.h sv.h thread.h time64.h unixish.h utf8.h
              util.h);
}

##!/data/data/com.pdaxrom.cctools/root/cctools/bin/sh
##
## This file was produced by running the Configure script. It holds all the
## definitions figured out by Configure. Should you modify one of these values,
## do not forget to propagate your changes by running "Configure -der". You may
## instead choose to run each of the .SH files by yourself, or "Configure -S".
##
#
## Package name      : perl5
## Source directory  : .
## Configuration time: Thu Aug 27 12:16:52 UTC 2015
## Configured by     : unknown
## Target system     : linux localhost 3.10.33 #1 smp preempt fri apr 17 07:07:43 cest 2015 armv7l gnulinux 
#
#: Configure command line arguments.
#
#: Variables propagated from previous config.sh file.

our $summary = <<'!END!';
Summary of my $package (revision $revision $version_patchlevel_string) configuration:
  $git_commit_id_title $git_commit_id$git_ancestor_line
  Platform:
    osname=$osname, osvers=$osvers, archname=$archname
    uname='$myuname'
    config_args='$config_args'
    hint=$hint, useposix=$useposix, d_sigaction=$d_sigaction
    useithreads=$useithreads, usemultiplicity=$usemultiplicity
    use64bitint=$use64bitint, use64bitall=$use64bitall, uselongdouble=$uselongdouble
    usemymalloc=$usemymalloc, bincompat5005=undef
  Compiler:
    cc='$cc', ccflags ='$ccflags',
    optimize='$optimize',
    cppflags='$cppflags'
    ccversion='$ccversion', gccversion='$gccversion', gccosandvers='$gccosandvers'
    intsize=$intsize, longsize=$longsize, ptrsize=$ptrsize, doublesize=$doublesize, byteorder=$byteorder, doublekind=$doublekind
    d_longlong=$d_longlong, longlongsize=$longlongsize, d_longdbl=$d_longdbl, longdblsize=$longdblsize, longdblkind=$longdblkind
    ivtype='$ivtype', ivsize=$ivsize, nvtype='$nvtype', nvsize=$nvsize, Off_t='$lseektype', lseeksize=$lseeksize
    alignbytes=$alignbytes, prototype=$prototype
  Linker and Libraries:
    ld='$ld', ldflags ='$ldflags'
    libpth=$libpth
    libs=$libs
    perllibs=$perllibs
    libc=$libc, so=$so, useshrplib=$useshrplib, libperl=$libperl
    gnulibc_version='$gnulibc_version'
  Dynamic Linking:
    dlsrc=$dlsrc, dlext=$dlext, d_dlsymun=$d_dlsymun, ccdlflags='$ccdlflags'
    cccdlflags='$cccdlflags', lddlflags='$lddlflags'

!END!
my $summary_expanded;

sub myconfig {
    return $summary_expanded if $summary_expanded;
    ($summary_expanded = $summary) =~ s{\$(\w+)}
		 { 
			my $c;
			if ($1 eq 'git_ancestor_line') {
				if ($Config::Config{git_ancestor}) {
					$c= "\n  Ancestor: $Config::Config{git_ancestor}";
				} else {
					$c= "";
				}
			} else {
                     		$c = $Config::Config{$1}; 
			}
			defined($c) ? $c : 'undef' 
		}ge;
    $summary_expanded;
}

local *_ = \my $a;
$_ = <<'!END!';
Author=''
CONFIG='true'
Date=''
Header=''
Id=''
Locker=''
Log=''
PATCHLEVEL='22'
PERL_API_REVISION='5'
PERL_API_SUBVERSION='0'
PERL_API_VERSION='22'
PERL_CONFIG_SH='true'
PERL_PATCHLEVEL=''
PERL_REVISION='5'
PERL_SUBVERSION='0'
PERL_VERSION='22'
RCSfile=''
Revision=''
SUBVERSION='0'
Source=''
State=''
_a='.a'
_exe=''
_o='.o'
afs='false'
afsroot='/afs'
alignbytes='8'
android_stub='FIX|Android'
android_warn=''
ansi2knr=''
aphostname='/data/data/com.pdaxrom.cctools/root/cctools/bin/hostname'
api_revision='5'
api_subversion='0'
api_version='22'
api_versionstring='5.22.0'
ar='ar'
archlib='/data/local/perl/bin/../lib/5.22.0/armv7l-linux-android'
archlibexp='/data/local/perl/bin/../lib/5.22.0/armv7l-linux-android'
archname64=''
archname='armv7l-linux-android'
archobjs=''
args=''
asctime_r_proto='0'
awk='awk'
baserev='5.0'
bash=''
bin='/data/local/perl/bin/'
bin_ELF='define'
binexp='/data/local/perl/bin/'
bison='bison'
byacc='byacc'
byteorder='1234'
c=''
castflags='1'
cat='cat'
cc='cc'
cccdlflags='-fPIC --sysroot=/data/data/com.pdaxrom.cctools/root/cctools'
ccdlflags='-Wl,-E'
ccflags='-fno-strict-aliasing -pipe -fstack-protector -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 -D_FORTIFY_SOURCE=2'
ccflags_uselargefiles='-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64'
ccname='gcc'
ccsymbols=''
ccversion=''
cf_by='unknown'
cf_email='unknown@localhost.nonet'
cf_time='Thu Aug 27 12:16:52 UTC 2015'
charbits='8'
charsize='1'
chgrp=''
chmod='chmod'
chown=''
clocktype='clock_t'
comm='comm'
compress=''
config_arg0='./Configure'
config_arg10='-Dvendorman1=none'
config_arg11='-Dvendorman3=none'
config_arg12='-des'
config_arg1='-Duserelocatableinc'
config_arg2='-Dusedevel'
config_arg3='-Dprefix=/data/local/perl'
config_arg4='-Dsysroot=/data/data/com.pdaxrom.cctools/root/cctools'
config_arg5='-Alibpth=/system/lib /vendor/lib'
config_arg6='-Dman1dir=none'
config_arg7='-Dman3dir=none'
config_arg8='-Dsite1man=none'
config_arg9='-Dsite3man=none'
config_argc='12'
config_args='-Duserelocatableinc -Dusedevel -Dprefix=/data/local/perl -Dsysroot=/data/data/com.pdaxrom.cctools/root/cctools -Alibpth=/system/lib /vendor/lib -Dman1dir=none -Dman3dir=none -Dsite1man=none -Dsite3man=none -Dvendorman1=none -Dvendorman3=none -des'
contains='grep'
cp='cp'
cpio=''
cpp='cpp'
cpp_stuff='42'
cppccsymbols=''
cppflags='-fno-strict-aliasing -pipe -fstack-protector'
cpplast='-'
cppminus='-'
cpprun='cc  -E'
cppstdin='cc  -E'
cppsymbols='_FILE_OFFSET_BITS=64 _LARGEFILE_SOURCE=1 __ACCUM_EPSILON__=0x1P-15K __ACCUM_FBIT__=15 __ACCUM_IBIT__=16 __ACCUM_MAX__=0X7FFFFFFFP-15K __ACCUM_MIN__=(-0X1P15K-0X1P15K) __ANDROID__=1 __APCS_32__=1 __ARMEL__=1 __ARM_ARCH=5 __ARM_ARCH_5TE__=1 __ARM_ARCH_ISA_ARM=1 __ARM_ARCH_ISA_THUMB=1 __ARM_EABI__=1 __ARM_FEATURE_CLZ=1 __ARM_FEATURE_DSP=1 __ARM_FEATURE_QBIT=1 __ARM_FP=12 __ARM_NEON_FP=4 __ARM_PCS=1 __ARM_SIZEOF_MINIMAL_ENUM=4 __ARM_SIZEOF_WCHAR_T=32 __ATOMIC_ACQUIRE=2 __ATOMIC_ACQ_REL=4 __ATOMIC_CONSUME=1 __ATOMIC_RELAXED=0 __ATOMIC_RELEASE=3 __ATOMIC_SEQ_CST=5 __BIGGEST_ALIGNMENT__=8 __BYTE_ORDER__=1234 __CHAR16_TYPE__=short\ unsigned\ int __CHAR32_TYPE__=unsigned\ int __CHAR_BIT__=8 __CHAR_UNSIGNED__=1 __DA_FBIT__=31 __DA_IBIT__=32 __DBL_DECIMAL_DIG__=17 __DBL_DENORM_MIN__=((double)4.9406564584124654e-324L) __DBL_DIG__=15 __DBL_EPSILON__=((double)2.2204460492503131e-16L) __DBL_HAS_DENORM__=1 __DBL_HAS_INFINITY__=1 __DBL_HAS_QUIET_NAN__=1 __DBL_MANT_DIG__=53 __DBL_MAX_10_EXP__=308 __DBL_MAX_EXP__=1024 __DBL_MAX__=((double)1.7976931348623157e+308L) __DBL_MIN_10_EXP__=(-307) __DBL_MIN_EXP__=(-1021) __DBL_MIN__=((double)2.2250738585072014e-308L) __DEC128_EPSILON__=1E-33DL __DEC128_MANT_DIG__=34 __DEC128_MAX_EXP__=6145 __DEC128_MAX__=9.999999999999999999999999999999999E6144DL __DEC128_MIN_EXP__=(-6142) __DEC128_MIN__=1E-6143DL __DEC128_SUBNORMAL_MIN__=0.000000000000000000000000000000001E-6143DL __DEC32_EPSILON__=1E-6DF __DEC32_MANT_DIG__=7 __DEC32_MAX_EXP__=97 __DEC32_MAX__=9.999999E96DF __DEC32_MIN_EXP__=(-94) __DEC32_MIN__=1E-95DF __DEC32_SUBNORMAL_MIN__=0.000001E-95DF __DEC64_EPSILON__=1E-15DD __DEC64_MANT_DIG__=16 __DEC64_MAX_EXP__=385 __DEC64_MAX__=9.999999999999999E384DD __DEC64_MIN_EXP__=(-382) __DEC64_MIN__=1E-383DD __DEC64_SUBNORMAL_MIN__=0.000000000000001E-383DD __DECIMAL_DIG__=17 __DEC_EVAL_METHOD__=2 __DQ_FBIT__=63 __DQ_IBIT__=0 __ELF__=1 __FINITE_MATH_ONLY__=0 __FLOAT_WORD_ORDER__=1234 __FLT_DECIMAL_DIG__=9 __FLT_DENORM_MIN__=1.4012984643248171e-45F __FLT_DIG__=6 __FLT_EPSILON__=1.1920928955078125e-7F __FLT_EVAL_METHOD__=0 __FLT_HAS_DENORM__=1 __FLT_HAS_INFINITY__=1 __FLT_HAS_QUIET_NAN__=1 __FLT_MANT_DIG__=24 __FLT_MAX_10_EXP__=38 __FLT_MAX_EXP__=128 __FLT_MAX__=3.4028234663852886e+38F __FLT_MIN_10_EXP__=(-37) __FLT_MIN_EXP__=(-125) __FLT_MIN__=1.1754943508222875e-38F __FLT_RADIX__=2 __FRACT_EPSILON__=0x1P-15R __FRACT_FBIT__=15 __FRACT_IBIT__=0 __FRACT_MAX__=0X7FFFP-15R __FRACT_MIN__=(-0.5R-0.5R) __GCC_ATOMIC_BOOL_LOCK_FREE=1 __GCC_ATOMIC_CHAR16_T_LOCK_FREE=1 __GCC_ATOMIC_CHAR32_T_LOCK_FREE=1 __GCC_ATOMIC_CHAR_LOCK_FREE=1 __GCC_ATOMIC_INT_LOCK_FREE=1 __GCC_ATOMIC_LLONG_LOCK_FREE=1 __GCC_ATOMIC_LONG_LOCK_FREE=1 __GCC_ATOMIC_POINTER_LOCK_FREE=1 __GCC_ATOMIC_SHORT_LOCK_FREE=1 __GCC_ATOMIC_TEST_AND_SET_TRUEVAL=1 __GCC_ATOMIC_WCHAR_T_LOCK_FREE=1 __GNUC_GNU_INLINE__=1 __GNUC_MINOR__=8 __GNUC_PATCHLEVEL__=0 __GNUC__=4 __GXX_ABI_VERSION=1002 __GXX_TYPEINFO_EQUALITY_INLINE=0 __HA_FBIT__=7 __HA_IBIT__=8 __HQ_FBIT__=15 __HQ_IBIT__=0 __INT16_C=__INT16_C __INT16_MAX__=32767 __INT16_TYPE__=short\ int __INT32_C=__INT32_C __INT32_MAX__=2147483647 __INT32_TYPE__=int __INT64_C=__INT64_C __INT64_MAX__=9223372036854775807LL __INT64_TYPE__=long\ long\ int __INT8_C=__INT8_C __INT8_MAX__=127 __INT8_TYPE__=signed\ char __INTMAX_C=__INTMAX_C __INTMAX_MAX__=9223372036854775807LL __INTMAX_TYPE__=long\ long\ int __INTPTR_MAX__=2147483647 __INTPTR_TYPE__=int __INT_FAST16_MAX__=2147483647 __INT_FAST16_TYPE__=int __INT_FAST32_MAX__=2147483647 __INT_FAST32_TYPE__=int __INT_FAST64_MAX__=9223372036854775807LL __INT_FAST64_TYPE__=long\ long\ int __INT_FAST8_MAX__=127 __INT_FAST8_TYPE__=signed\ char __INT_LEAST16_MAX__=32767 __INT_LEAST16_TYPE__=short\ int __INT_LEAST32_MAX__=2147483647 __INT_LEAST32_TYPE__=int __INT_LEAST64_MAX__=9223372036854775807LL __INT_LEAST64_TYPE__=long\ long\ int __INT_LEAST8_MAX__=127 __INT_LEAST8_TYPE__=signed\ char __INT_MAX__=2147483647 __LACCUM_EPSILON__=0x1P-31LK __LACCUM_FBIT__=31 __LACCUM_IBIT__=32 __LACCUM_MAX__=0X7FFFFFFFFFFFFFFFP-31LK __LACCUM_MIN__=(-0X1P31LK-0X1P31LK) __LDBL_DENORM_MIN__=4.9406564584124654e-324L __LDBL_DIG__=15 __LDBL_EPSILON__=2.2204460492503131e-16L __LDBL_HAS_DENORM__=1 __LDBL_HAS_INFINITY__=1 __LDBL_HAS_QUIET_NAN__=1 __LDBL_MANT_DIG__=53 __LDBL_MAX_10_EXP__=308 __LDBL_MAX_EXP__=1024 __LDBL_MAX__=1.7976931348623157e+308L __LDBL_MIN_10_EXP__=(-307) __LDBL_MIN_EXP__=(-1021) __LDBL_MIN__=2.2250738585072014e-308L __LFRACT_EPSILON__=0x1P-31LR __LFRACT_FBIT__=31 __LFRACT_IBIT__=0 __LFRACT_MAX__=0X7FFFFFFFP-31LR __LFRACT_MIN__=(-0.5LR-0.5LR) __LLACCUM_EPSILON__=0x1P-31LLK __LLACCUM_FBIT__=31 __LLACCUM_IBIT__=32 __LLACCUM_MAX__=0X7FFFFFFFFFFFFFFFP-31LLK __LLACCUM_MIN__=(-0X1P31LLK-0X1P31LLK) __LLFRACT_EPSILON__=0x1P-63LLR __LLFRACT_FBIT__=63 __LLFRACT_IBIT__=0 __LLFRACT_MAX__=0X7FFFFFFFFFFFFFFFP-63LLR __LLFRACT_MIN__=(-0.5LLR-0.5LLR) __LONG_LONG_MAX__=9223372036854775807LL __LONG_MAX__=2147483647L __ORDER_BIG_ENDIAN__=4321 __ORDER_LITTLE_ENDIAN__=1234 __ORDER_PDP_ENDIAN__=3412 __PIC__=1 __PRAGMA_REDEFINE_EXTNAME=1 __PTRDIFF_MAX__=2147483647 __PTRDIFF_TYPE__=int __QQ_FBIT__=7 __QQ_IBIT__=0 __REGISTER_PREFIX__= __SACCUM_EPSILON__=0x1P-7HK __SACCUM_FBIT__=7 __SACCUM_IBIT__=8 __SACCUM_MAX__=0X7FFFP-7HK __SACCUM_MIN__=(-0X1P7HK-0X1P7HK) __SA_FBIT__=15 __SA_IBIT__=16 __SCHAR_MAX__=127 __SFRACT_EPSILON__=0x1P-7HR __SFRACT_FBIT__=7 __SFRACT_IBIT__=0 __SFRACT_MAX__=0X7FP-7HR __SFRACT_MIN__=(-0.5HR-0.5HR) __SHRT_MAX__=32767 __SIG_ATOMIC_MAX__=2147483647 __SIG_ATOMIC_MIN__=(-2147483647\ -\ 1) __SIG_ATOMIC_TYPE__=int __SIZEOF_DOUBLE__=8 __SIZEOF_FLOAT__=4 __SIZEOF_INT__=4 __SIZEOF_LONG_DOUBLE__=8 __SIZEOF_LONG_LONG__=8 __SIZEOF_LONG__=4 __SIZEOF_POINTER__=4 __SIZEOF_PTRDIFF_T__=4 __SIZEOF_SHORT__=2 __SIZEOF_SIZE_T__=4 __SIZEOF_WCHAR_T__=4 __SIZEOF_WINT_T__=4 __SIZE_MAX__=4294967295U __SIZE_TYPE__=unsigned\ int __SOFTFP__=1 __SQ_FBIT__=31 __SQ_IBIT__=0 __STDC_HOSTED__=1 __STDC__=1 __TA_FBIT__=63 __TA_IBIT__=64 __THUMB_INTERWORK__=1 __TQ_FBIT__=127 __TQ_IBIT__=0 __UACCUM_EPSILON__=0x1P-16UK __UACCUM_FBIT__=16 __UACCUM_IBIT__=16 __UACCUM_MAX__=0XFFFFFFFFP-16UK __UACCUM_MIN__=0.0UK __UDA_FBIT__=32 __UDA_IBIT__=32 __UDQ_FBIT__=64 __UDQ_IBIT__=0 __UFRACT_EPSILON__=0x1P-16UR __UFRACT_FBIT__=16 __UFRACT_IBIT__=0 __UFRACT_MAX__=0XFFFFP-16UR __UFRACT_MIN__=0.0UR __UHA_FBIT__=8 __UHA_IBIT__=8 __UHQ_FBIT__=16 __UHQ_IBIT__=0 __UINT16_C=__UINT16_C __UINT16_MAX__=65535 __UINT16_TYPE__=short\ unsigned\ int __UINT32_C=__UINT32_C __UINT32_MAX__=4294967295U __UINT32_TYPE__=unsigned\ int __UINT64_C=__UINT64_C __UINT64_MAX__=18446744073709551615ULL __UINT64_TYPE__=long\ long\ unsigned\ int __UINT8_C=__UINT8_C __UINT8_MAX__=255 __UINT8_TYPE__=unsigned\ char __UINTMAX_C=__UINTMAX_C __UINTMAX_MAX__=18446744073709551615ULL __UINTMAX_TYPE__=long\ long\ unsigned\ int __UINTPTR_MAX__=4294967295U __UINTPTR_TYPE__=unsigned\ int __UINT_FAST16_MAX__=4294967295U __UINT_FAST16_TYPE__=unsigned\ int __UINT_FAST32_MAX__=4294967295U __UINT_FAST32_TYPE__=unsigned\ int __UINT_FAST64_MAX__=18446744073709551615ULL __UINT_FAST64_TYPE__=long\ long\ unsigned\ int __UINT_FAST8_MAX__=255 __UINT_FAST8_TYPE__=unsigned\ char __UINT_LEAST16_MAX__=65535 __UINT_LEAST16_TYPE__=short\ unsigned\ int __UINT_LEAST32_MAX__=4294967295U __UINT_LEAST32_TYPE__=unsigned\ int __UINT_LEAST64_MAX__=18446744073709551615ULL __UINT_LEAST64_TYPE__=long\ long\ unsigned\ int __UINT_LEAST8_MAX__=255 __UINT_LEAST8_TYPE__=unsigned\ char __ULACCUM_EPSILON__=0x1P-32ULK __ULACCUM_FBIT__=32 __ULACCUM_IBIT__=32 __ULACCUM_MAX__=0XFFFFFFFFFFFFFFFFP-32ULK __ULACCUM_MIN__=0.0ULK __ULFRACT_EPSILON__=0x1P-32ULR __ULFRACT_FBIT__=32 __ULFRACT_IBIT__=0 __ULFRACT_MAX__=0XFFFFFFFFP-32ULR __ULFRACT_MIN__=0.0ULR __ULLACCUM_EPSILON__=0x1P-32ULLK __ULLACCUM_FBIT__=32 __ULLACCUM_IBIT__=32 __ULLACCUM_MAX__=0XFFFFFFFFFFFFFFFFP-32ULLK __ULLACCUM_MIN__=0.0ULLK __ULLFRACT_EPSILON__=0x1P-64ULLR __ULLFRACT_FBIT__=64 __ULLFRACT_IBIT__=0 __ULLFRACT_MAX__=0XFFFFFFFFFFFFFFFFP-64ULLR __ULLFRACT_MIN__=0.0ULLR __UQQ_FBIT__=8 __UQQ_IBIT__=0 __USACCUM_EPSILON__=0x1P-8UHK __USACCUM_FBIT__=8 __USACCUM_IBIT__=8 __USACCUM_MAX__=0XFFFFP-8UHK __USACCUM_MIN__=0.0UHK __USA_FBIT__=16 __USA_IBIT__=16 __USER_LABEL_PREFIX__= __USFRACT_EPSILON__=0x1P-8UHR __USFRACT_FBIT__=8 __USFRACT_IBIT__=0 __USFRACT_MAX__=0XFFP-8UHR __USFRACT_MIN__=0.0UHR __USQ_FBIT__=32 __USQ_IBIT__=0 __UTA_FBIT__=64 __UTA_IBIT__=64 __UTQ_FBIT__=128 __UTQ_IBIT__=0 __VERSION__="4.8" __VFP_FP__=1 __WCHAR_MAX__=4294967295U __WCHAR_MIN__=0U __WCHAR_TYPE__=unsigned\ int __WINT_MAX__=4294967295U __WINT_MIN__=0U __WINT_TYPE__=unsigned\ int __arm__=1 __linux=1 __linux__=1 __pic__=1 __unix=1 __unix__=1 linux=1 unix=1'
crypt_r_proto='0'
cryptlib=''
csh='csh'
ctermid_r_proto='0'
ctime_r_proto='0'
d_Gconvert='sprintf((b),"%.*g",(n),(x))'
d_PRIEUldbl='define'
d_PRIFUldbl='define'
d_PRIGUldbl='define'
d_PRIXU64='define'
d_PRId64='define'
d_PRIeldbl='define'
d_PRIfldbl='define'
d_PRIgldbl='define'
d_PRIi64='define'
d_PRIo64='define'
d_PRIu64='define'
d_PRIx64='define'
d_SCNfldbl='define'
d__fwalk='undef'
d_access='define'
d_accessx='undef'
d_acosh='define'
d_aintl='undef'
d_alarm='define'
d_archlib='define'
d_asctime64='define'
d_asctime_r='undef'
d_asinh='define'
d_atanh='define'
d_atolf='undef'
d_atoll='define'
d_attribute_deprecated='define'
d_attribute_format='define'
d_attribute_malloc='define'
d_attribute_nonnull='define'
d_attribute_noreturn='define'
d_attribute_pure='define'
d_attribute_unused='define'
d_attribute_warn_unused_result='define'
d_backtrace='undef'
d_bcmp='undef'
d_bcopy='define'
d_bsd='undef'
d_bsdgetpgrp='undef'
d_bsdsetpgrp='undef'
d_builtin_choose_expr='define'
d_builtin_expect='define'
d_bzero='define'
d_c99_variadic_macros='define'
d_casti32='define'
d_castneg='undef'
d_cbrt='define'
d_charvspr='undef'
d_chown='define'
d_chroot='define'
d_chsize='undef'
d_class='undef'
d_clearenv='define'
d_closedir='define'
d_cmsghdr_s='define'
d_const='define'
d_copysign='define'
d_copysignl='define'
d_cplusplus='undef'
d_crypt='undef'
d_crypt_r='undef'
d_csh='undef'
d_ctermid='undef'
d_ctermid_r='undef'
d_ctime64='define'
d_ctime_r='undef'
d_cuserid='undef'
d_dbl_dig='define'
d_dbminitproto='undef'
d_difftime64='undef'
d_difftime='define'
d_dir_dd_fd='undef'
d_dirfd='define'
d_dirnamlen='undef'
d_dladdr='define'
d_dlerror='define'
d_dlopen='define'
d_dlsymun='undef'
d_dosuid='undef'
d_drand48_r='undef'
d_drand48proto='define'
d_dup2='define'
d_eaccess='undef'
d_endgrent='undef'
d_endgrent_r='undef'
d_endhent='undef'
d_endhostent_r='undef'
d_endnent='undef'
d_endnetent_r='undef'
d_endpent='undef'
d_endprotoent_r='undef'
d_endpwent='undef'
d_endpwent_r='undef'
d_endsent='define'
d_endservent_r='undef'
d_eofnblk='define'
d_erf='define'
d_erfc='define'
d_eunice='undef'
d_exp2='define'
d_expm1='define'
d_faststdio='define'
d_fchdir='define'
d_fchmod='define'
d_fchown='define'
d_fcntl='define'
d_fcntl_can_lock='define'
d_fd_macros='define'
d_fd_set='define'
d_fdim='define'
d_fds_bits='define'
d_fegetround='define'
d_fgetpos='define'
d_finite='define'
d_finitel='undef'
d_flexfnam='define'
d_flock='define'
d_flockproto='define'
d_fma='define'
d_fmax='define'
d_fmin='define'
d_fork='define'
d_fp_class='undef'
d_fp_classify='undef'
d_fp_classl='undef'
d_fpathconf='define'
d_fpclass='undef'
d_fpclassify='define'
d_fpclassl='undef'
d_fpgetround='undef'
d_fpos64_t='undef'
d_frexpl='define'
d_fs_data_s='undef'
d_fseeko='define'
d_fsetpos='define'
d_fstatfs='define'
d_fstatvfs='define'
d_fsync='define'
d_ftello='define'
d_ftime='undef'
d_futimes='undef'
d_gdbm_ndbm_h_uses_prototypes='undef'
d_gdbmndbm_h_uses_prototypes='undef'
d_getaddrinfo='define'
d_getcwd='define'
d_getespwnam='undef'
d_getfsstat='undef'
d_getgrent='undef'
d_getgrent_r='undef'
d_getgrgid_r='undef'
d_getgrnam_r='undef'
d_getgrps='define'
d_gethbyaddr='define'
d_gethbyname='define'
d_gethent='define'
d_gethname='define'
d_gethostbyaddr_r='undef'
d_gethostbyname_r='undef'
d_gethostent_r='undef'
d_gethostprotos='define'
d_getitimer='define'
d_getlogin='define'
d_getlogin_r='undef'
d_getmnt='undef'
d_getmntent='define'
d_getnameinfo='define'
d_getnbyaddr='define'
d_getnbyname='define'
d_getnent='undef'
d_getnetbyaddr_r='undef'
d_getnetbyname_r='undef'
d_getnetent_r='undef'
d_getnetprotos='undef'
d_getpagsz='define'
d_getpbyname='define'
d_getpbynumber='define'
d_getpent='undef'
d_getpgid='define'
d_getpgrp2='undef'
d_getpgrp='define'
d_getppid='define'
d_getprior='define'
d_getprotobyname_r='undef'
d_getprotobynumber_r='undef'
d_getprotoent_r='undef'
d_getprotoprotos='undef'
d_getprpwnam='undef'
d_getpwent='undef'
d_getpwent_r='undef'
d_getpwnam_r='undef'
d_getpwuid_r='undef'
d_getsbyname='define'
d_getsbyport='define'
d_getsent='define'
d_getservbyname_r='undef'
d_getservbyport_r='undef'
d_getservent_r='undef'
d_getservprotos='define'
d_getspnam='undef'
d_getspnam_r='undef'
d_gettimeod='define'
d_gmtime64='define'
d_gmtime_r='undef'
d_gnulibc='undef'
d_grpasswd='define'
d_hasmntopt='undef'
d_htonl='define'
d_hypot='define'
d_ilogb='define'
d_ilogbl='define'
d_inc_version_list='undef'
d_index='undef'
d_inetaton='define'
d_inetntop='define'
d_inetpton='define'
d_int64_t='define'
d_ip_mreq='define'
d_ip_mreq_source='undef'
d_ipv6_mreq='define'
d_ipv6_mreq_source='undef'
d_isascii='define'
d_isblank='define'
d_isfinite='define'
d_isfinitel='define'
d_isinf='define'
d_isinfl='define'
d_isless='undef'
d_isnan='define'
d_isnanl='define'
d_isnormal='define'
d_j0='define'
d_j0l='undef'
d_killpg='define'
d_lc_monetary_2008='undef'
d_lchown='define'
d_ldbl_dig='define'
d_ldexpl='define'
d_lgamma='define'
d_lgamma_r='define'
d_libm_lib_version='undef'
d_libname_unique='define'
d_link='define'
d_llrint='define'
d_llrintl='define'
d_llround='define'
d_llroundl='define'
d_localtime64='define'
d_localtime_r='undef'
d_localtime_r_needs_tzset='undef'
d_locconv='undef'
d_lockf='undef'
d_log1p='define'
d_log2='define'
d_logb='define'
d_longdbl='define'
d_longlong='define'
d_lrint='define'
d_lrintl='define'
d_lround='define'
d_lroundl='define'
d_lseekproto='define'
d_lstat='define'
d_madvise='define'
d_malloc_good_size='undef'
d_malloc_size='undef'
d_mblen='undef'
d_mbstowcs='define'
d_mbtowc='define'
d_memchr='define'
d_memcmp='define'
d_memcpy='define'
d_memmove='define'
d_memset='define'
d_mkdir='define'
d_mkdtemp='define'
d_mkfifo='define'
d_mkstemp='define'
d_mkstemps='define'
d_mktime64='define'
d_mktime='define'
d_mmap='define'
d_modfl='define'
d_modfl_pow32_bug='undef'
d_modflproto='define'
d_mprotect='define'
d_msg='undef'
d_msg_ctrunc='define'
d_msg_dontroute='define'
d_msg_oob='define'
d_msg_peek='define'
d_msg_proxy='undef'
d_msgctl='undef'
d_msgget='undef'
d_msghdr_s='define'
d_msgrcv='undef'
d_msgsnd='undef'
d_msync='define'
d_munmap='define'
d_mymalloc='undef'
d_nan='define'
d_ndbm='undef'
d_ndbm_h_uses_prototypes='undef'
d_nearbyint='define'
d_nextafter='define'
d_nexttoward='define'
d_nice='define'
d_nl_langinfo='undef'
d_nv_preserves_uv='define'
d_nv_zero_is_allbits_zero='define'
d_off64_t='define'
d_old_pthread_create_joinable='undef'
d_oldpthreads='undef'
d_oldsock='undef'
d_open3='define'
d_pathconf='define'
d_pause='define'
d_perl_otherlibdirs='undef'
d_phostname='undef'
d_pipe='define'
d_poll='define'
d_portable='define'
d_prctl='define'
d_prctl_set_name='define'
d_printf_format_null='define'
d_procselfexe='undef'
d_pseudofork='undef'
d_pthread_atfork='define'
d_pthread_attr_setscope='define'
d_pthread_yield='undef'
d_ptrdiff_t='define'
d_pwage='undef'
d_pwchange='undef'
d_pwclass='undef'
d_pwcomment='undef'
d_pwexpire='undef'
d_pwgecos='undef'
d_pwpasswd='define'
d_pwquota='undef'
d_qgcvt='undef'
d_quad='define'
d_random_r='undef'
d_re_comp='undef'
d_readdir64_r='undef'
d_readdir='define'
d_readdir_r='undef'
d_readlink='define'
d_readv='define'
d_recvmsg='define'
d_regcmp='undef'
d_regcomp='define'
d_remainder='define'
d_remquo='define'
d_rename='define'
d_rewinddir='define'
d_rint='define'
d_rmdir='define'
d_round='define'
d_safebcpy='undef'
d_safemcpy='undef'
d_sanemcmp='define'
d_sbrkproto='define'
d_scalbn='define'
d_scalbnl='define'
d_sched_yield='define'
d_scm_rights='define'
d_seekdir='undef'
d_select='define'
d_sem='undef'
d_semctl='undef'
d_semctl_semid_ds='undef'
d_semctl_semun='undef'
d_semget='undef'
d_semop='undef'
d_sendmsg='define'
d_setegid='define'
d_seteuid='define'
d_setgrent='undef'
d_setgrent_r='undef'
d_setgrps='define'
d_sethent='undef'
d_sethostent_r='undef'
d_setitimer='define'
d_setlinebuf='define'
d_setlocale='undef'
d_setlocale_r='undef'
d_setnent='undef'
d_setnetent_r='undef'
d_setpent='undef'
d_setpgid='define'
d_setpgrp2='undef'
d_setpgrp='define'
d_setprior='define'
d_setproctitle='undef'
d_setprotoent_r='undef'
d_setpwent='undef'
d_setpwent_r='undef'
d_setregid='define'
d_setresgid='define'
d_setresuid='define'
d_setreuid='define'
d_setrgid='undef'
d_setruid='undef'
d_setsent='define'
d_setservent_r='undef'
d_setsid='define'
d_setvbuf='define'
d_shm='undef'
d_shmat='undef'
d_shmatprototype='undef'
d_shmctl='undef'
d_shmdt='undef'
d_shmget='undef'
d_sigaction='define'
d_signbit='define'
d_sigprocmask='define'
d_sigsetjmp='define'
d_sin6_scope_id='define'
d_sitearch='define'
d_snprintf='define'
d_sockaddr_in6='define'
d_sockaddr_sa_len='undef'
d_sockatmark='undef'
d_sockatmarkproto='undef'
d_socket='define'
d_socklen_t='define'
d_sockpair='define'
d_socks5_init='undef'
d_sprintf_returns_strlen='define'
d_sqrtl='define'
d_srand48_r='undef'
d_srandom_r='undef'
d_sresgproto='define'
d_sresuproto='define'
d_stat='define'
d_statblks='define'
d_statfs_f_flags='define'
d_statfs_s='define'
d_static_inline='define'
d_statvfs='define'
d_stdio_cnt_lval='define'
d_stdio_ptr_lval='define'
d_stdio_ptr_lval_nochange_cnt='define'
d_stdio_ptr_lval_sets_cnt='undef'
d_stdio_stream_array='define'
d_stdiobase='undef'
d_stdstdio='define'
d_strchr='define'
d_strcoll='define'
d_strctcpy='define'
d_strerrm='strerror(e)'
d_strerror='define'
d_strerror_r='undef'
d_strftime='define'
d_strlcat='define'
d_strlcpy='define'
d_strtod='define'
d_strtol='define'
d_strtold='define'
d_strtoll='define'
d_strtoq='define'
d_strtoul='define'
d_strtoull='define'
d_strtouq='define'
d_strxfrm='define'
d_suidsafe='undef'
d_symlink='define'
d_syscall='define'
d_syscallproto='undef'
d_sysconf='define'
d_sysernlst=''
d_syserrlst='undef'
d_system='define'
d_tcgetpgrp='define'
d_tcsetpgrp='define'
d_telldir='undef'
d_telldirproto='undef'
d_tgamma='define'
d_time='define'
d_timegm='define'
d_times='define'
d_tm_tm_gmtoff='define'
d_tm_tm_zone='define'
d_tmpnam_r='undef'
d_trunc='define'
d_truncate='define'
d_truncl='define'
d_ttyname_r='undef'
d_tzname='define'
d_u32align='undef'
d_ualarm='undef'
d_umask='define'
d_uname='define'
d_union_semun='undef'
d_unordered='undef'
d_unsetenv='define'
d_usleep='define'
d_usleepproto='define'
d_ustat='undef'
d_vendorarch='undef'
d_vendorbin='undef'
d_vendorlib='undef'
d_vendorscript='undef'
d_vfork='undef'
d_void_closedir='undef'
d_voidsig='define'
d_voidtty=''
d_volatile='define'
d_vprintf='define'
d_vsnprintf='define'
d_wait4='define'
d_waitpid='define'
d_wcscmp='define'
d_wcstombs='define'
d_wcsxfrm='define'
d_wctomb='define'
d_writev='define'
d_xenix='undef'
date='date'
db_hashtype='u_int32_t'
db_prefixtype='size_t'
db_version_major=''
db_version_minor=''
db_version_patch=''
direntrytype='struct dirent'
dlext='so'
dlsrc='dl_dlopen.xs'
doexit=''
doublekind='3'
doublesize='8'
drand01='Perl_drand48()'
drand48_r_proto='0'
dtrace=''
dynamic_ext='B Compress/Raw/Bzip2 Compress/Raw/Zlib Cwd Data/Dumper Devel/PPPort Devel/Peek Digest/MD5 Digest/SHA Encode Fcntl File/DosGlob File/Glob Filter/Util/Call Hash/Util Hash/Util/FieldHash IO List/Util MIME/Base64 Math/BigInt/FastCalc Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via SDBM_File Socket Storable Sys/Hostname Sys/Syslog Tie/Hash/NamedCapture Time/HiRes Time/Piece Unicode/Collate XS/APItest XS/Typemap arybase attributes mro re threads threads/shared'
eagain='EAGAIN'
ebcdic='undef'
echo='echo'
egrep='egrep'
emacs=''
endgrent_r_proto='0'
endhostent_r_proto='0'
endnetent_r_proto='0'
endprotoent_r_proto='0'
endpwent_r_proto='0'
endservent_r_proto='0'
env=''
eunicefix=':'
exe=''
exe_ext=''
expr='expr'
extensions='B Compress/Raw/Bzip2 Compress/Raw/Zlib Cwd Data/Dumper Devel/PPPort Devel/Peek Digest/MD5 Digest/SHA Encode Fcntl File/DosGlob File/Glob Filter/Util/Call Hash/Util Hash/Util/FieldHash IO List/Util MIME/Base64 Math/BigInt/FastCalc Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via SDBM_File Socket Storable Sys/Hostname Sys/Syslog Tie/Hash/NamedCapture Time/HiRes Time/Piece Unicode/Collate XS/APItest XS/Typemap arybase attributes mro re threads threads/shared Archive/Tar Attribute/Handlers AutoLoader B/Debug CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Carp Config/Perl/V Devel/SelfStubber Digest Dumpvalue Env Errno Exporter ExtUtils/CBuilder ExtUtils/Command ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/Miniperl ExtUtils/ParseXS File/Fetch File/Find File/Path File/Temp FileCache Filter/Simple Getopt/Long HTTP/Tiny I18N/Collate I18N/LangTags IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/Open3 JSON/PP Locale/Codes Locale/Maketext Locale/Maketext/Simple Math/BigInt Math/BigRat Math/Complex Memoize Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NEXT Net/Ping Params/Check Parse/CPAN/Meta Perl/OSType PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Functions Pod/Html Pod/Parser Pod/Perldoc Pod/Simple Pod/Usage Safe Search/Dict SelfLoader Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Test Test/Harness Test/Simple Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Memoize Tie/RefHash Time/Local Unicode/Normalize XSLoader autodie autouse base bignum constant encoding/warnings experimental if lib libnet parent perlfaq podlators version'
extern_C='extern'
extras=''
fflushNULL='define'
fflushall='undef'
find=''
firstmakefile='makefile'
flex=''
fpossize='4'
fpostype='fpos_t'
freetype='void'
from=':'
full_ar='/data/data/com.pdaxrom.cctools/root/cctools/bin/ar'
full_csh='csh'
full_sed='/data/data/com.pdaxrom.cctools/root/cctools/bin/sed'
gccansipedantic=''
gccosandvers=''
gccversion='4.8'
getgrent_r_proto='0'
getgrgid_r_proto='0'
getgrnam_r_proto='0'
gethostbyaddr_r_proto='0'
gethostbyname_r_proto='0'
gethostent_r_proto='0'
getlogin_r_proto='0'
getnetbyaddr_r_proto='0'
getnetbyname_r_proto='0'
getnetent_r_proto='0'
getprotobyname_r_proto='0'
getprotobynumber_r_proto='0'
getprotoent_r_proto='0'
getpwent_r_proto='0'
getpwnam_r_proto='0'
getpwuid_r_proto='0'
getservbyname_r_proto='0'
getservbyport_r_proto='0'
getservent_r_proto='0'
getspnam_r_proto='0'
gidformat='"lu"'
gidsign='1'
gidsize='4'
gidtype='gid_t'
glibpth=' /data/data/com.pdaxrom.cctools/root/cctools/usr/shlib /data/data/com.pdaxrom.cctools/root/cctools/lib /data/data/com.pdaxrom.cctools/root/cctools/usr/lib /data/data/com.pdaxrom.cctools/root/cctools/usr/lib/386 /data/data/com.pdaxrom.cctools/root/cctools/lib/386 /data/data/com.pdaxrom.cctools/root/cctools/usr/ccs/lib /data/data/com.pdaxrom.cctools/root/cctools/usr/ucblib /data/data/com.pdaxrom.cctools/root/cctools/usr/local/lib'
gmake='gmake'
gmtime_r_proto='0'
gnulibc_version=''
grep='grep'
groupcat=''
groupstype='gid_t'
gzip='gzip'
h_fcntl='false'
h_sysfile='true'
hint='recommended'
hostcat='cat /etc/hosts'
hostgenerate=''
hostosname=''
hostperl=''
html1dir=' '
html1direxp=''
html3dir=' '
html3direxp=''
i16size='2'
i16type='short'
i32size='4'
i32type='long'
i64size='8'
i64type='long long'
i8size='1'
i8type='signed char'
i_arpainet='define'
i_assert='define'
i_bfd='undef'
i_bsdioctl=''
i_crypt='undef'
i_db='undef'
i_dbm='undef'
i_dirent='define'
i_dlfcn='define'
i_execinfo='undef'
i_fcntl='undef'
i_fenv='define'
i_float='define'
i_fp='undef'
i_fp_class='undef'
i_gdbm='undef'
i_gdbm_ndbm='undef'
i_gdbmndbm='undef'
i_grp='define'
i_ieeefp='undef'
i_inttypes='define'
i_langinfo='undef'
i_libutil='undef'
i_limits='define'
i_locale='undef'
i_machcthr='undef'
i_malloc='define'
i_mallocmalloc='undef'
i_math='define'
i_memory='undef'
i_mntent='define'
i_ndbm='undef'
i_netdb='define'
i_neterrno='undef'
i_netinettcp='define'
i_niin='define'
i_poll='define'
i_prot='undef'
i_pthread='define'
i_pwd='define'
i_quadmath='undef'
i_rpcsvcdbm='undef'
i_sgtty='define'
i_shadow='undef'
i_socks='undef'
i_stdarg='define'
i_stdbool='define'
i_stddef='define'
i_stdint='define'
i_stdlib='define'
i_string='define'
i_sunmath='undef'
i_sysaccess='undef'
i_sysdir='undef'
i_sysfile='define'
i_sysfilio='undef'
i_sysin='undef'
i_sysioctl='define'
i_syslog='define'
i_sysmman='define'
i_sysmode='undef'
i_sysmount='define'
i_sysndir='undef'
i_sysparam='define'
i_syspoll='define'
i_sysresrc='define'
i_syssecrt='undef'
i_sysselct='define'
i_syssockio='undef'
i_sysstat='define'
i_sysstatfs='define'
i_sysstatvfs='undef'
i_systime='define'
i_systimek='undef'
i_systimes='define'
i_systypes='define'
i_sysuio='define'
i_sysun='define'
i_sysutsname='define'
i_sysvfs='define'
i_syswait='define'
i_termio='undef'
i_termios='undef'
i_time='define'
i_unistd='define'
i_ustat='undef'
i_utime='define'
i_values='undef'
i_varargs='undef'
i_varhdr='stdarg.h'
i_vfork='undef'
ignore_versioned_solibs='y'
inc_version_list=''
inc_version_list_init='0'
incpath=''
incpth='/data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/include /data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/include-fixed /data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/../../../../arm-linux-androideabi/include'
inews=''
initialinstalllocation='/data/local/perl/bin'
installarchlib='/data/local/perl/bin/../lib/5.22.0/armv7l-linux-android'
installbin='/data/local/perl/bin'
installhtml1dir=''
installhtml3dir=''
installman1dir=''
installman3dir=''
installprefix='/data/local/perl'
installprefixexp='/data/local/perl/bin/..'
installprivlib='/data/local/perl/bin/../lib/5.22.0'
installscript='/data/local/perl/bin/'
installsitearch='/data/local/perl/bin/../lib/site_perl/5.22.0/armv7l-linux-android'
installsitebin='/data/local/perl/bin/../bin'
installsitehtml1dir=''
installsitehtml3dir=''
installsitelib='/data/local/perl/bin/../lib/site_perl/5.22.0'
installsiteman1dir=''
installsiteman3dir=''
installsitescript='/data/local/perl/bin/../bin'
installstyle='lib'
installusrbinperl='undef'
installvendorarch=''
installvendorbin=''
installvendorhtml1dir=''
installvendorhtml3dir=''
installvendorlib=''
installvendorman1dir=''
installvendorman3dir=''
installvendorscript=''
intsize='4'
issymlink='test -h'
ivdformat='"ld"'
ivsize='4'
ivtype='long'
known_extensions='Archive/Tar Attribute/Handlers AutoLoader B B/Debug CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Carp Compress/Raw/Bzip2 Compress/Raw/Zlib Config/Perl/V Cwd DB_File Data/Dumper Devel/PPPort Devel/Peek Devel/SelfStubber Digest Digest/MD5 Digest/SHA Dumpvalue Encode Env Errno Exporter ExtUtils/CBuilder ExtUtils/Command ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/Miniperl ExtUtils/ParseXS Fcntl File/DosGlob File/Fetch File/Find File/Glob File/Path File/Temp FileCache Filter/Simple Filter/Util/Call GDBM_File Getopt/Long HTTP/Tiny Hash/Util Hash/Util/FieldHash I18N/Collate I18N/LangTags I18N/Langinfo IO IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/Open3 IPC/SysV JSON/PP List/Util Locale/Codes Locale/Maketext Locale/Maketext/Simple MIME/Base64 Math/BigInt Math/BigInt/FastCalc Math/BigRat Math/Complex Memoize Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NDBM_File NEXT Net/Ping ODBM_File Opcode POSIX Params/Check Parse/CPAN/Meta Perl/OSType PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Functions Pod/Html Pod/Parser Pod/Perldoc Pod/Simple Pod/Usage SDBM_File Safe Search/Dict SelfLoader Socket Storable Sys/Hostname Sys/Syslog Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Test Test/Harness Test/Simple Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Hash/NamedCapture Tie/Memoize Tie/RefHash Time/HiRes Time/Local Time/Piece Unicode/Collate Unicode/Normalize VMS/DCLsym VMS/Filespec VMS/Stdio Win32 Win32API/File Win32CORE XS/APItest XS/Typemap XSLoader arybase attributes autodie autouse base bignum constant encoding/warnings experimental if lib libnet mro parent perlfaq podlators re threads threads/shared version '
ksh=''
ld='cc'
ld_can_script='define'
lddlflags='-shared -O2 --sysroot /data/data/com.pdaxrom.cctools/root/cctools -L/system/lib -fstack-protector'
ldflags=' -L/system/lib -fstack-protector'
ldflags_uselargefiles=''
ldlibpthname='LD_LIBRARY_PATH'
less='less'
lib_ext='.a'
libc='/system/lib/libc.so'
libperl='libperl.a'
libpth='/system/lib /vendor/lib /data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/include-fixed /data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/../../../../arm-linux-androideabi/lib /data/data/com.pdaxrom.cctools/root/cctools/lib /system/lib /vendor/lib /system/lib /vendor/lib /system/lib /vendor/lib'
libs='-ldl -lm -lc'
libsdirs=' /system/lib'
libsfiles=' libdl.so libm.so libc.so'
libsfound=' /system/lib/libdl.so /system/lib/libm.so /system/lib/libc.so'
libspath=' /system/lib /vendor/lib /data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/include-fixed /data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/../../../../arm-linux-androideabi/lib /data/data/com.pdaxrom.cctools/root/cctools/lib'
libswanted='cl pthread socket inet nsl nm gdbm dbm db malloc dl ld sun m crypt sec util c cposix posix ucb BSD m gdbm_compat'
libswanted_uselargefiles=''
line=''
lint=''
lkflags=''
ln='ln'
lns='/data/data/com.pdaxrom.cctools/root/cctools/bin/ln -s'
localtime_r_proto='0'
locincpth=' /data/data/com.pdaxrom.cctools/root/cctools/usr/local/include /data/data/com.pdaxrom.cctools/root/cctools/opt/local/include /data/data/com.pdaxrom.cctools/root/cctools/usr/gnu/include /data/data/com.pdaxrom.cctools/root/cctools/opt/gnu/include /data/data/com.pdaxrom.cctools/root/cctools/usr/GNU/include /data/data/com.pdaxrom.cctools/root/cctools/opt/GNU/include'
loclibpth=' /data/data/com.pdaxrom.cctools/root/cctools/usr/local/lib /data/data/com.pdaxrom.cctools/root/cctools/opt/local/lib /data/data/com.pdaxrom.cctools/root/cctools/usr/gnu/lib /data/data/com.pdaxrom.cctools/root/cctools/opt/gnu/lib /data/data/com.pdaxrom.cctools/root/cctools/usr/GNU/lib /data/data/com.pdaxrom.cctools/root/cctools/opt/GNU/lib'
longdblkind='0'
longdblsize='8'
longlongsize='8'
longsize='4'
lp=''
lpr=''
ls='ls'
lseeksize='4'
lseektype='off_t'
mail=''
mailx=''
make='make'
make_set_make='#'
mallocobj=''
mallocsrc=''
malloctype='void *'
man1dir=' '
man1direxp=''
man1ext='0'
man3dir=' '
man3direxp=''
man3ext='0'
mips_type=''
mistrustnm=''
mkdir='mkdir'
mmaptype='void *'
modetype='mode_t'
more='more'
multiarch='undef'
mv=''
myarchname='armv7l-linux-android'
mydomain='.nonet'
myhostname='localhost'
myuname='linux localhost 3.10.33 #1 smp preempt fri apr 17 07:07:43 cest 2015 armv7l gnulinux '
n='-n'
need_va_copy='undef'
netdb_hlen_type='int'
netdb_host_type='const char *'
netdb_name_type='const char *'
netdb_net_type='unsigned int'
nm='nm'
nm_opt=''
nm_so_opt='--dynamic'
nonxs_ext='Archive/Tar Attribute/Handlers AutoLoader B/Debug CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Carp Config/Perl/V Devel/SelfStubber Digest Dumpvalue Env Errno Exporter ExtUtils/CBuilder ExtUtils/Command ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/Miniperl ExtUtils/ParseXS File/Fetch File/Find File/Path File/Temp FileCache Filter/Simple Getopt/Long HTTP/Tiny I18N/Collate I18N/LangTags IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/Open3 JSON/PP Locale/Codes Locale/Maketext Locale/Maketext/Simple Math/BigInt Math/BigRat Math/Complex Memoize Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NEXT Net/Ping Params/Check Parse/CPAN/Meta Perl/OSType PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Functions Pod/Html Pod/Parser Pod/Perldoc Pod/Simple Pod/Usage Safe Search/Dict SelfLoader Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Test Test/Harness Test/Simple Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Memoize Tie/RefHash Time/Local Unicode/Normalize XSLoader autodie autouse base bignum constant encoding/warnings experimental if lib libnet parent perlfaq podlators version'
nroff='nroff'
nvEUformat='"E"'
nvFUformat='"F"'
nvGUformat='"G"'
nv_overflows_integers_at='256.0*256.0*256.0*256.0*256.0*256.0*2.0*2.0*2.0*2.0*2.0'
nv_preserves_uv_bits='32'
nveformat='"e"'
nvfformat='"f"'
nvgformat='"g"'
nvsize='8'
nvtype='double'
o_nonblock='O_NONBLOCK'
obj_ext='.o'
old_pthread_create_joinable=''
optimize='-O2'
orderlib='false'
osname='android'
osvers='5.0.2'
otherlibdirs=' '
package='perl5'
pager='/data/data/com.pdaxrom.cctools/root/cctools/bin/less'
passcat=''
patchlevel='22'
path_sep=':'
perl5=''
perl='perl'
perl_patchlevel=''
perl_static_inline='static __inline__'
perladmin='unknown@localhost.nonet'
perllibs='-ldl -lm -lc'
perlpath='/data/local/perl/bin/perl5.22.0'
pg='pg'
phostname='hostname'
pidtype='pid_t'
plibpth='/mnt/nfs/Work/cctools-pro/tmp-pie/arm-repo/cctools-host/sysroot/lib/arm-linux-androideabi/4.8 /mnt/nfs/Work/cctools-pro/tmp-pie/arm-repo/cctools-host/sysroot/lib /mnt/nfs/Work/cctools-pro/tmp-pie/arm-repo/cctools-host/sysroot/usr/lib/arm-linux-androideabi/4.8 /mnt/nfs/Work/cctools-pro/tmp-pie/arm-repo/cctools-host/sysroot/usr/lib'
pmake=''
pr=''
prefix='/data/local/perl/bin/..'
prefixexp='/data/local/perl/bin/..'
privlib='/data/local/perl/bin/../lib/5.22.0'
privlibexp='/data/local/perl/bin/../lib/5.22.0'
procselfexe=''
prototype='define'
ptrsize='4'
quadkind='3'
quadtype='long long'
randbits='48'
randfunc='Perl_drand48'
random_r_proto='0'
randseedtype='U32'
ranlib=':'
rd_nodata='-1'
readdir64_r_proto='0'
readdir_r_proto='0'
result_status=''
revision='5'
rm='rm'
rm_try='/data/data/com.pdaxrom.cctools/root/cctools/bin/rm -f try try a.out .out try.[cho] try..o core core.try* try.core*'
rmail=''
run=''
runnm='true'
sGMTIME_max='2147483647'
sGMTIME_min='-2147483648'
sLOCALTIME_max='2147483647'
sLOCALTIME_min='-2147483648'
sPRIEUldbl='"E"'
sPRIFUldbl='"F"'
sPRIGUldbl='"G"'
sPRIXU64='"llX"'
sPRId64='"lld"'
sPRIeldbl='"e"'
sPRIfldbl='"f"'
sPRIgldbl='"g"'
sPRIi64='"lli"'
sPRIo64='"llo"'
sPRIu64='"llu"'
sPRIx64='"llx"'
sSCNfldbl='"f"'
sched_yield='sched_yield()'
scriptdir='/data/local/perl/bin/'
scriptdirexp='/data/local/perl/bin/'
sed='sed'
seedfunc='Perl_drand48_init'
selectminbits='32'
selecttype='fd_set *'
sendmail=''
setgrent_r_proto='0'
sethostent_r_proto='0'
setlocale_r_proto='0'
setnetent_r_proto='0'
setprotoent_r_proto='0'
setpwent_r_proto='0'
setservent_r_proto='0'
sh='/system/bin/sh'
shar=''
sharpbang='#!'
shmattype=''
shortsize='2'
shrpenv=''
shsharp='true'
sig_count='32'
sig_name='ZERO HUP INT QUIT ILL TRAP ABRT BUS FPE KILL USR1 SEGV USR2 PIPE ALRM TERM STKFLT CHLD CONT STOP TSTP TTIN TTOU URG XCPU XFSZ VTALRM PROF WINCH IO PWR SYS IOT POLL UNUSED SWI '
sig_name_init='"ZERO", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "BUS", "FPE", "KILL", "USR1", "SEGV", "USR2", "PIPE", "ALRM", "TERM", "STKFLT", "CHLD", "CONT", "STOP", "TSTP", "TTIN", "TTOU", "URG", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "IO", "PWR", "SYS", "IOT", "POLL", "UNUSED", "SWI", 0'
sig_num='0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 6 29 31 32 '
sig_num_init='0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 6, 29, 31, 32, 0'
sig_size='36'
signal_t='void'
sitearch='/data/local/perl/bin/../lib/site_perl/5.22.0/armv7l-linux-android'
sitearchexp='/data/local/perl/bin/../lib/site_perl/5.22.0/armv7l-linux-android'
sitebin='/data/local/perl/bin/../bin'
sitebinexp='/data/local/perl/bin/../bin'
sitehtml1dir=''
sitehtml1direxp=''
sitehtml3dir=''
sitehtml3direxp=''
sitelib='/data/local/perl/bin/../lib/site_perl/5.22.0'
sitelib_stem='/data/local/perl/bin/../lib/site_perl'
sitelibexp='/data/local/perl/bin/../lib/site_perl/5.22.0'
siteman1dir=''
siteman1direxp=''
siteman3dir=''
siteman3direxp=''
siteprefix='/data/local/perl/bin/..'
siteprefixexp='/data/local/perl/bin/..'
sitescript='/data/local/perl/bin/../bin'
sitescriptexp='/data/local/perl/bin/../bin'
sizesize='4'
sizetype='size_t'
sleep=''
smail=''
so='so'
sockethdr=''
socketlib=''
socksizetype='socklen_t'
sort='sort'
spackage='Perl5'
spitshell='cat'
srand48_r_proto='0'
srandom_r_proto='0'
src='.'
ssizetype='ssize_t'
st_ino_sign='1'
st_ino_size='8'
startperl='#!/data/local/perl/bin/perl5.22.0'
startsh='#!/data/data/com.pdaxrom.cctools/root/cctools/bin/sh'
static_ext=' '
stdchar='char'
stdio_base='((fp)->_ub._base ? (fp)->_ub._base : (fp)->_bf._base)'
stdio_bufsiz='((fp)->_ub._base ? (fp)->_ub._size : (fp)->_bf._size)'
stdio_cnt='((fp)->_r)'
stdio_filbuf=''
stdio_ptr='((fp)->_p)'
stdio_stream_array='__sF'
strerror_r_proto='0'
strings='/data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/../../../../arm-linux-androideabi/include/string.h'
submit=''
subversion='0'
sysman='/usr/man/man1'
sysroot='/data/data/com.pdaxrom.cctools/root/cctools'
tail=''
tar=''
targetarch=''
targetdir=''
targetenv=''
targetfrom=''
targethost=''
targetmkdir=''
targetport=''
targetrun=''
targetsh='/system/bin/sh'
targetto=''
tbl=''
tee=''
test='test'
timeincl='/data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/../../../../arm-linux-androideabi/include/sys/time.h /data/data/com.pdaxrom.cctools/root/cctools/bin/../lib/gcc/arm-linux-androideabi/4.8/../../../../arm-linux-androideabi/include/time.h '
timetype='time_t'
tmpnam_r_proto='0'
to=':'
touch='touch'
tr='tr'
trnl='\n'
troff=''
ttyname_r_proto='0'
u16size='2'
u16type='unsigned short'
u32size='4'
u32type='unsigned long'
u64size='8'
u64type='unsigned long long'
u8size='1'
u8type='unsigned char'
uidformat='"lu"'
uidsign='1'
uidsize='4'
uidtype='uid_t'
uname='uname'
uniq='uniq'
uquadtype='unsigned long long'
use5005threads='undef'
use64bitall='undef'
use64bitint='undef'
usecbacktrace='undef'
usecrosscompile='undef'
usedevel='define'
usedl='define'
usedtrace='undef'
usefaststdio='undef'
useithreads='undef'
usekernprocpathname='undef'
uselargefiles='define'
uselongdouble='undef'
usemallocwrap='define'
usemorebits='undef'
usemultiplicity='undef'
usemymalloc='n'
usenm='true'
usensgetexecutablepath='undef'
useopcode='true'
useperlio='define'
useposix='true'
usequadmath='undef'
usereentrant='undef'
userelocatableinc='define'
useshrplib='false'
usesitecustomize='undef'
usesocks='undef'
usethreads='undef'
usevendorprefix='undef'
useversionedarchname='undef'
usevfork='false'
usrinc='/data/data/com.pdaxrom.cctools/root/cctools/usr/include'
uuname=''
uvXUformat='"lX"'
uvoformat='"lo"'
uvsize='4'
uvtype='unsigned long'
uvuformat='"lu"'
uvxformat='"lx"'
vaproto='define'
vendorarch=''
vendorarchexp=''
vendorbin=''
vendorbinexp=''
vendorhtml1dir=' '
vendorhtml1direxp=''
vendorhtml3dir=' '
vendorhtml3direxp=''
vendorlib=''
vendorlib_stem=''
vendorlibexp=''
vendorman1dir=' '
vendorman1direxp=''
vendorman3dir=' '
vendorman3direxp=''
vendorprefix=''
vendorprefixexp=''
vendorscript=''
vendorscriptexp=''
version='5.22.0'
version_patchlevel_string='version 22 subversion 0'
versiononly='define'
vi=''
xlibpth=' /data/data/com.pdaxrom.cctools/root/cctools/usr/lib/386 /data/data/com.pdaxrom.cctools/root/cctools/lib/386'
yacc='yacc'
yaccflags=''
zcat=''
zip='zip'
!END!

my $i = ord(4);
foreach my $c (3,2,1) { $i <<= 8; $i |= ord($c); }
our $byteorder = join('', unpack('aaaa', pack('L!', $i)));
foreach my $what (qw(prefixexp archlibexp privlibexp scriptdirexp sitearchexp sitebinexp sitelibexp sitescriptexp siteprefixexp sitelib_stem installarchlib installprefixexp installprivlib installscript installsitearch installsitebin installsitelib installsitescript)) {
    s/^($what=)(['"])(.*?)\2/$1 . $2 . relocate_inc($3) . $2/me;
}
s/(byteorder=)(['"]).*?\2/$1$2$Config::byteorder$2/m;

my $config_sh_len = length $_;

our $Config_SH_expanded = "\n$_" . << 'EOVIRTUAL';
ccflags_nolargefiles='-fno-strict-aliasing -pipe -fstack-protector  -D_FORTIFY_SOURCE=2'
ldflags_nolargefiles=' -L/system/lib -fstack-protector'
libs_nolargefiles='-ldl -lm -lc'
libswanted_nolargefiles='cl pthread socket inet nsl nm gdbm dbm db malloc dl ld sun m crypt sec util c cposix posix ucb BSD m gdbm_compat'
ccwarnflags=' -Wall -Werror=declaration-after-statement -Wextra -Wc++-compat -Wwrite-strings'
EOVIRTUAL
eval {
	# do not have hairy conniptions if this isnt available
	require 'Config_git.pl';
	$Config_SH_expanded .= $Config::Git_Data;
	1;
} or warn "Warning: failed to load Config_git.pl, something strange about this perl...\n";

# Search for it in the big string
sub fetch_string {
    my($self, $key) = @_;

    return undef unless $Config_SH_expanded =~ /\n$key=\'(.*?)\'\n/s;
    # So we can say "if $Config{'foo'}".
    $self->{$key} = $1 eq 'undef' ? undef : $1;
}

my $prevpos = 0;

sub FIRSTKEY {
    $prevpos = 0;
    substr($Config_SH_expanded, 1, index($Config_SH_expanded, '=') - 1 );
}

sub NEXTKEY {
    my $pos = index($Config_SH_expanded, qq('\n), $prevpos) + 2;
    my $len = index($Config_SH_expanded, "=", $pos) - $pos;
    $prevpos = $pos;
    $len > 0 ? substr($Config_SH_expanded, $pos, $len) : undef;
}

sub EXISTS {
    return 1 if exists($_[0]->{$_[1]});

    return(index($Config_SH_expanded, "\n$_[1]='") != -1
          );
}

sub STORE  { die "\%Config::Config is read-only\n" }
*DELETE = *CLEAR = \*STORE; # Typeglob aliasing uses less space

sub config_sh {
    substr $Config_SH_expanded, 1, $config_sh_len;
}

sub config_re {
    my $re = shift;
    return map { chomp; $_ } grep eval{ /^(?:$re)=/ }, split /^/,
    $Config_SH_expanded;
}

sub config_vars {
    # implements -V:cfgvar option (see perlrun -V:)
    foreach (@_) {
	# find optional leading, trailing colons; and query-spec
	my ($notag,$qry,$lncont) = m/^(:)?(.*?)(:)?$/;	# flags fore and aft, 
	# map colon-flags to print decorations
	my $prfx = $notag ? '': "$qry=";		# tag-prefix for print
	my $lnend = $lncont ? ' ' : ";\n";		# line ending for print

	# all config-vars are by definition \w only, any \W means regex
	if ($qry =~ /\W/) {
	    my @matches = config_re($qry);
	    print map "$_$lnend", @matches ? @matches : "$qry: not found"		if !$notag;
	    print map { s/\w+=//; "$_$lnend" } @matches ? @matches : "$qry: not found"	if  $notag;
	} else {
	    my $v = (exists $Config::Config{$qry}) ? $Config::Config{$qry}
						   : 'UNKNOWN';
	    $v = 'undef' unless defined $v;
	    print "${prfx}'${v}'$lnend";
	}
    }
}

# Called by the real AUTOLOAD
sub launcher {
    undef &AUTOLOAD;
    goto \&$Config::AUTOLOAD;
}

1;
