# 
#
# Magisk init script to start the syslogd
#
# History
#   26.08.2024 /bs
#     initial relase
#     
#
WAIT_TIME=20

# for debugging the script enable the next command 
# 
#set -x

exec 1>/data/local/tmp/start_syslog_init_script.log 2>&1


SEMFILE="/data/local/tmp/disable_syslogd"

SYSLOGD_START_SCRIPT="system/bin/start_syslogd"

if [ ! -r ${SEMFILE} ] ; then
  if [ ! -x ${SYSLOGD_START_SCRIPT} ] ; then
    echo "ERROR: The start script \"${SYSLOGD_START_SCRIPT}\" does not exist -- can not start the syslogd"
  else
   echo "Waiting now ${WAIT_TIME} seconds before starting the syslogd to make sure the bind mount for /system/etc/hosts is in place ..."
   ( sleep ${WAIT_TIME}  ;  ${SYSLOGD_START_SCRIPT}  ) &
  fi
else
  echo "The file \"${SEMFILE}\" exists - starting the syslogd is disabled"
fi


