# 
# Magisk init script service.sh for the Magisk Module
#
# History
#   04.09.2024 /bs
#     initial release
#   22.09.2025 /bs
#     added the missing definitions for __TRUE and __FALSE
#
# use the command
#
#   resetprop -w sys.boot_completed 0
#
# to wait until the boot is complete
#

#

# -----------------------------------------------------------------------------
# define some constants
#
__TRUE=0
__FALSE=1


# -----------------------------------------------------------------------------
#
# the environment variable MODPATH is only defined by Magisk for the script customize.sh
#
[ "${MODPATH}"x = ""x ] && MODPATH="${0%/*}"

MODULE_NAME="$( grep "^id=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"
[ "${MODULE_NAME}"x = ""x ] && MODULE_NAME="unknown_magisk_module"

MODULE_VERSION="$( grep "^version=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"

MODULE_DESC="${MODULE_NAME} ${MODULE_VERSION}"

# customize.sh is sourced in
# #
[ "$0"x = "sh"x ] && SCRIPT_NAME="customize.sh" || SCRIPT_NAME="${0##*/}"

# ----------------------------------------------------------------------------
#
# LogDebugMsg - print a Message if DEBUG_MODE is ${__TRUE}
# 
# Usage: LogDebugMsg [message]
#
function LogDebugMsg {
  if [ ${DEBUG_MODE} = ${__TRUE} ] ; then
    echo "$*"
  fi
}

# -----------------------------------------------------------------------------
# change either "0 = 1" to "0 = 0" in this script or create the file /data/local/tmp/debug to enable the debug output to the log file
#
if [ 0 = 1 -o -r /data/local/tmp/debug ] ; then
  LOGFILE="/data/local/tmp/${MODULE_NAME}_${SCRIPT_NAME}.log"

#  echo "Writing all messages to the log file ${LOGFILE}"

  exec 1>"${LOGFILE}" 2>&1

  if [ -r /data/local/tmp/trace ] ; then
    set -x
    TRACE_MODE=${__TRUE}
  else
    TRACE_MODE=${__FALSE}    
  fi
  
  DEBUG_MODE=${__TRUE}   
else
  DEBUG_MODE=${__FALSE}     
  TRACE_MODE=${__FALSE}  
fi

# -----

echo "This is the script $0 for the module \"${MODULE_NAME}\" "

UNINSTALL_PLAYSTORE_UPDATE_SCRIPT="${MODPATH}/uninstall_playstore_update.sh"

if [ -x "${UNINSTALL_PLAYSTORE_UPDATE_SCRIPT}"  ] ; then
  echo "${UNINSTALL_PLAYSTORE_UPDATE_SCRIPT} found - now executing it ..."

  echo "Waiting until the boot is complete ..."
  resetprop -w sys.boot_completed 0

  ${UNINSTALL_PLAYSTORE_UPDATE_SCRIPT} -x -r
fi

# wait until the boot is complete:
#
# resetprop -w sys.boot_completed 0.
#


