# 
# Magisk script action.sh for the Magisk Module with the Playstore
#
# Note: All messages written to STDOUT are displayed in the Magisk output window 
#
# History
#  31.10.2024 /bs
#     initial release
#   06.05.2025 /bs
#     added code to write messages to the Magisk output window even if STDOUT is redirected to a file  
#     added the variables MODULE_VERSION and MODULE_DESC
#     "set -x" is now only executed if the files /data/local/tmp/debug and /data/local/tmp/trace exist
#  22.09.2025 /bs
#     added the missing definitions for __TRUE and __FALSE
#     added the environment variable IN_ACTION_SCRIPT
#

# -----------------------------------------------------------------------------
# define some constants
#
__TRUE=0
__FALSE=1

export IN_ACTION_SCRIPT=${__TRUE}

# -----------------------------------------------------------------------------
#
# the environment variable MODPATH is only defined by Magisk for the script customize.sh
#
[ "${MODPATH}"x = ""x ] && MODPATH="${0%/*}"

MODULE_NAME="$( grep "^id=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"
[ "${MODULE_NAME}"x = ""x ] && MODULE_NAME="unknown_magisk_module"

MODULE_VERSION="$( grep "^version=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"

MODULE_DESC="${MODULE_NAME} ${MODULE_VERSION}"

# customize.sh is sourced in
# #
[ "$0"x = "sh"x ] && SCRIPT_NAME="customize.sh" || SCRIPT_NAME="${0##*/}"


# -----------------------------------------------------------------------------
# save the file handle for STDOUT to file handle 5 ( &5 is used in the function printMsg )
#
exec 5>&1

# ----------------------------------------------------------------------------
#
# printMsg - print a Message to the Magisk output window even if redirection of STDOUT to the logfile is enabled
# 
# Usage: printMsg [message]
#
function printMsg {
   echo "$*" >&5
}

# ----------------------------------------------------------------------------
#
# LogDebugMsg - print a Message if DEBUG_MODE is ${__TRUE}
# 
# Usage: LogDebugMsg [message]
#
function LogDebugMsg {
  if [ ${DEBUG_MODE} = ${__TRUE} ] ; then
    echo "$*"
  fi
}

# -----------------------------------------------------------------------------
# change either "0 = 1" to "0 = 0" in this script or create the file /data/local/tmp/debug to enable the debug output to the log file
#
if [ 0 = 1  -o -r /data/local/tmp/debug ] ; then
  LOGFILE="/data/local/tmp/${MODULE_NAME}_${SCRIPT_NAME}.log"

  printMsg  "----"
  printMsg  "Messages to STDOUT are now redirected to the log file 
  ${LOGFILE}"
  printMsg  "----"

  exec 1>"${LOGFILE}" 2>&1
  
  if [ -r /data/local/tmp/trace ] ; then
    set -x
    TRACE_MODE=${__TRUE}
  else
    TRACE_MODE=${__FALSE}    
  fi

  DEBUG_MODE=${__TRUE}   
else
  DEBUG_MODE=${__FALSE}     
  TRACE_MODE=${__FALSE}
fi

# ----------------------------------------------------------------------------

printMsg "Uninstalling the PlayStore update ...."

if [ -x /system/bin/uninstall_playstore_update.sh ] ; then
	/system/bin/uninstall_playstore_update.sh  -f -r 2>&1
else
	echo "ERROR: The script /system/bin/uninstall_playstore_update.sh does not exist"
fi

