
The Magisk Module contains the Playstore version 28.3.16.21 for arm64 CPUs

The Magisk Module was successfully tested in Android 13, 14, 15, and 16.

The Magisk Module requires an installed MicroG (https://microg.org/)

The Magisk Module disables an installed FakeStore from MicroG.

The customize script searches the FakeStore in these directories:

     /system/priv-app
     /system/product/priv-app
     /system/system_ext/priv-app
     /system/vendor/priv-app
     /product/priv-app
     /system_ext/priv-app
     /vendor/priv-app
 

Update 06.09.2025

The Play Store updates automatically. This works fine until Play Store version 47.7.19-31 is installed: this version works until the phone is restarted; after restarting, the Play Store no longer launches (the problem may also occur with earlier versions of the Play Store—I can no longer test this).


There is no known fix for this behaviour. To get the Playstore working again do:

     force stop the Playstore in the system settings
     clear the cache and storage for the Playstore in the system settings
     uninstall all updates for the Playstore in the system settings
     reboot the phone

Or execute the script

/system/bin/uninstall_playstore_update.sh

as user root to uninstall the Playstore update. The usage for the script is:

ASUS_I006D:/ $ su - -c /system/bin/uninstall_playstore_update.sh -h

 uninstall_playstore_update.sh v1.0.0 - uninstall a Playstore update

 Usage: uninstall_playstore_update.sh  [-h|--help] [-d|--dryrun] [-x|--doit] [-f|--force] [-r|--reboot] [-v|--verbose] [-V|--version] [var=value]

 Use the parameter "-h -v" to print the detailed usage help

ASUS_I006D:/ $ 


The script does nothing without the parameter -x or -f, e.g:

# output of the script if no Playstore update is currently installed

ASUS_I006D:/ # su - -c /system/bin/uninstall_playstore_update.sh 
No Playstore update found (The current path to the Playstore is "/system/priv-app/Google.Phonesky/Phonesky.apk" )

4|ASUS_I006D:/ #


# output of the script if a Playstore update is currently installed

ASUS_I006D:/ # su - -c /system/bin/uninstall_playstore_update.sh
There is an update for the Playstore installed in the directory "/data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/":

drwxrwxr-x 4 system system   u:object_r:apk_data_file:s0              3452 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/
-rw-r--r-- 1 system system   u:object_r:apk_data_file:s0          54131604 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/base.apk
drwxr-xr-x 3 system system   u:object_r:apk_data_file:s0              3452 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/lib
drwxr-xr-x 2 system system   u:object_r:apk_data_file:s0              3452 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/lib/arm64
drwxr-x--x 3 system system   u:object_r:dalvikcache_data_file:s0      3452 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/oat
drwxr-x--x 2 system system   u:object_r:dalvikcache_data_file:s0      3452 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/oat/arm64
-rw-r--r-- 1 system all_a119 u:object_r:dalvikcache_data_file:s0    447328 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/oat/arm64/base.odex
-rw-r--r-- 1 system all_a119 u:object_r:dalvikcache_data_file:s0   1390312 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/oat/arm64/base.vdex
-rw-r--r-- 1 system system   u:object_r:apk_data_file:s0           9196517 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/split_config.arm64_v8a.apk
-rw-r--r-- 1 system system   u:object_r:apk_data_file:s0            565657 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/split_config.en.apk
-rw-r--r-- 1 system system   u:object_r:apk_data_file:s0             16534 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/split_phonesky_data_loader.apk
-rw-r--r-- 1 system system   u:object_r:apk_data_file:s0             70067 2025-09-06 17:38 /data/app/~~WoL-d2Goggm6A2VumbZZQQ==/com.android.vending-lFYze4lg0LwesWzzey6lYQ==/split_phonesky_data_loader.config.arm64_v8a.apk

Checking if the Playstore is running ...
u0_a119      12450   930 23 17:38:28 ?    00:00:06 com.android.vending
The Playstore is running
Nothing to do right now (use the parameter "-f" or "--force" to uninstall the Playstore update anyway

3|ASUS_I006D:/ # 


The command to uninstall the Playstore update in any case and reboot the phone if neccessary is

su - -c  /system/bin/uninstall_playstore_update.sh -r -f


To automatically uninstall any not working Playstore update after a reboot create this symbolic link after installing this Magisk Module:

su - -c ln -s ./system/bin/uninstall_playstore_update.sh /data/adb/modules/PlayStore_for_MicroG/uninstall_playstore_update.sh


The documentation for this Magisk Module is here:

https://bnsmb.de/My_HowTos_for_Android.html#How_to_replace_the_FakeStore_in_MicroG_with_the_original_Playstore


The documentation for creating Magisk Modules is here: 

https://topjohnwu.github.io/Magisk/guides.html



History

  28.3.16.21-v1.0.0 

    initial release

  03.09.2025 28.3.16.21-v1.1.0
    the customize script now searches the FakeStore in the directories
      /system/priv-app
      /system/product/priv-app
      /system/system_ext/priv-app
      /system/vendor/priv-app
      /product/priv-app
      /system_ext/priv-app
      /vendor/priv-app

  06.09.2025 28.3.16-21.v1.2.0
     added the permission file /system/etc/permissions/privapp-permissions-com.android.vending.xml
     the FakeStore is now replaced with an nearly empty directory using the Magisk special file .replace
     added the script /system/bin/uninstall_playstore_update.sh to uninstall the Playstore update
 
