#
# Customiztion script for the Magisk Module PlayStore_for_MicroG
#
# History
#   11.06.2022 /bs
#     initial release
#
# Notes:
#
# This Magisk Module is for ARM64 CPUs only
#
# The files for the playstore are from the NanoDroid:  https://nanolx.org/
#
# Documentation for creating Magisk Modules: https://topjohnwu.github.io/Magisk/guides.html
#
# Envrionment variables that can be used:
#
#    MAGISK_VER (string): the version string of current installed Magisk (e.g. v20.0)
#    MAGISK_VER_CODE (int): the version code of current installed Magisk (e.g. 20000)
#    BOOTMODE (bool): true if the module is being installed in the Magisk app
#    MODPATH (path): the path where your module files should be installed
#    TMPDIR (path): a place where you can temporarily store files
#    ZIPFILE (path): your module’s installation zip
#    ARCH (string): the CPU architecture of the device. Value is either arm, arm64, x86, or x64
#    IS64BIT (bool): true if $ARCH is either arm64 or x64
#    API (int): the API level (Android version) of the device (e.g. 21 for Android 5.0)
#

# -----------------------------------------------------------------------------

# define constants
#
__TRUE=0
__FALSE=1


# -----------------------------------------------------------------------------
# init global variables
#

MODULE_VERSION="1.0.0.0"

FAKE_STORE_DIR="/system/priv-app/FakeStore"
PHONESKY_DIR="/system/priv-app/Phonesky"

FORCE_SEMAPHOR_FILE="/sdcard/Download/force_installation_of_patched_playstore"

ALREADY_INSTALLED_SEMAPHOR_FILE="/system/priv-app/FakeStore/Fakestore_disabled_by_Playstore_for_MicroG"

# -----------------------------------------------------------------------------

function LogMsg {
  ui_print "$*"
}

function LogInfo {
  LogMsg "INFO: $*"
}

function LogWarning {
  LogMsg "WARNING: $*"
}

function LogError {
  LogMsg "ERROR: $*"
}

# returns: ${__TRUE}  - semaphor exists
#          ${__FALSE} - semaphor does NOT exist
#
function check_for_force_semaphor {
  LOCAL_THISRC=${__FALSE}

  if [ "${FORCE_SEMAPHOR_FILE}"x != ""x  ] ; then
    if [ -r "${FORCE_SEMAPHOR_FILE}" ] ; then
       LogInfo "The file \"${FORCE_SEMAPHOR_FILE}\" exists -- the installation will continue"
       LOCAL_THISRC=${__TRUE}
    else
      LogMsg "Create the file \"${FORCE_SEMAPHOR_FILE}\" before installing this Magisk Module to force the installation"
    fi
  fi

 return ${LOCAL_THISRC}
}

# -----------------------------------------------------------------------------

LogMsg "The current envrironment for this installation is"

LogMsg "The version of the installed Magisk is \"${MAGISK_VER}\" (${MAGISK_VER_CODE})"

LogInfo "BOOTMODE is \"${BOOTMODE}\" "
LogInfo "MODPATH is \"${MODPATH}\" "
LogInfo "TMPDIR is \"${TMPDIR}\" "
LogInfo "ZIPFILE is \"${ZIPFILE}\" "
LogInfo "ARCH is \"${ARCH}\" "
LogInfo "IS64BIT is \"${IS64BIT}\" "
LogInfo "API is \"${API}\" "

# -----------------------------------------------------------------------------

# example output for the variables:


#  The version of the installed Magisk is "25.0" (25000)
#  INFO: BOOTMODE is "true" 
#  INFO: MODPATH is "/data/adb/modules_update/PlayStore_for_MicroG" 
#  INFO: TMPDIR is "/dev/tmp" 
#  INFO: ZIPFILE is "/data/user/0/com.topjohnwu.magisk/cache/flash/install.zip" 
#  INFO: ARCH is "arm64" 
#  /data/user/0/com.topjohnwu.magisk/cache/flash/update-binary: /data/adb/modules_update/PlayStore_for_MicroG/customize.sh: line 115: can't create .//system/priv-app/FakeStore/Fakestore_disabled_by_Playstore_for_MicroG: nonexistent directory
#  INFO: IS64BIT is "true" 
#  INFO: API is "32"


# -----------------------------------------------------------------------------

LogMsg "Installing the Magisk Module for the patched Playstore version \"${MODULE_VERSION}\" ..."

LogMsg "Checking the OS configuration ..."

ERRORS_FOUND=${__FALSE}

LogMsg "Checking the directories used for the patched Playstore ..."

# update the version number for the module
#
echo "${MODULE_VERSION}"  >"./${ALREADY_INSTALLED_SEMAPHOR_FILE}"

# retrieve the version number of an already installed version of this Module (if any)
#
INSTALLED_MODULE_VERSION="$( cat "${ALREADY_INSTALLED_SEMAPHOR_FILE}" 2>/dev/null )"

if [ "${INSTALLED_MODULE_VERSION}"x != ""x ] ; then
  LogMsg "This is an update of the installed Module; the version of the installed Module is \"${INSTALLED_MODULE_VERSION}\" "
else
  if [ ! -d "${FAKE_STORE_DIR}" ] ; then
    LogInfo "The directory \"${FAKE_STORE_DIR}\" does not exist"  
  fi  

  if [ -d "${PHONESKY_DIR}" ] ; then
    LogError "The directory \"${PHONESKY_DIR}\" already exists"
    ERRORS_FOUND=${__TRUE}
  fi
fi


LogMsg "Checking tf the MicroG packages are installed ..."

CUR_OUTPUT="$( pm list packages )"
if [ $? -ne 0 ] ; then
  LogError "Error retrieving the list of installed packages via \"pm list packages\" "
  ERRORS_FOUND=${__TRUE}
else
  echo "${CUR_OUTPUT}" | grep microg 
  if [ $? -ne 0 ] ; then
    LogError "No installed MicroG packages found"
    ERRORS_FOUND=${__TRUE}
  fi
fi

# check the current CPU
#
LogMsg "Checking the type of the CPU used in this device ...."
LogMsg "The CPU in this device is a ${ARCH} CPU"

if [ "${ARCH}"x = "arm64"x ] ; then
  LogMsg "OK, the CPU is supported by this module"
else
  LogError "This Module does not support the CPU on this device"
  ERRORS_FOUND=${__TRUE} 
fi

if [ ${ERRORS_FOUND} = ${__TRUE} ] ; then
  check_for_force_semaphor || abort "ERRROR: One or more errors in the prerequisite checks found"
fi

