#
# History
#   14.04.2024 /bs
#     initial release
#
# Notes:
#
# see README.TXT
#
# Environment variables that can be used:
#
#    MAGISK_VER (string): the version string of current installed Magisk (e.g. v20.0)
#    MAGISK_VER_CODE (int): the version code of current installed Magisk (e.g. 20000)
#    BOOTMODE (bool): true if the module is being installed in the Magisk app
#    MODPATH (path): the path where your module files should be installed
#    TMPDIR (path): a place where you can temporarily store files
#    ZIPFILE (path): your module’s installation zip
#    ARCH (string): the CPU architecture of the device. Value is either arm, arm64, x86, or x64
#    IS64BIT (bool): true if $ARCH is either arm64 or x64
#    API (int): the API level (Android version) of the device (e.g. 21 for Android 5.0)
#

# -----------------------------------------------------------------------------

# define constants
#
__TRUE=0
__FALSE=1


# -----------------------------------------------------------------------------
# init global variables
#

MODULE_VERSION="34.0.3"


FORCE_SEMAPHOR_FILE="/sdcard/Download/force_installation_of_androidsdk3403"

# -----------------------------------------------------------------------------

function LogMsg {
  ui_print "$*"
}

function LogInfo {
  LogMsg "INFO: $*"
}

function LogWarning {
  LogMsg "WARNING: $*"
}

function LogError {
  LogMsg "ERROR: $*"
}

# returns: ${__TRUE}  - semaphor exists
#          ${__FALSE} - semaphor does NOT exist
#
function check_for_force_semaphor {
  LOCAL_THISRC=${__FALSE}

  if [ "${FORCE_SEMAPHOR_FILE}"x != ""x  ] ; then
    if [ -r "${FORCE_SEMAPHOR_FILE}" ] ; then
       LogInfo "The file \"${FORCE_SEMAPHOR_FILE}\" exists -- the installation will continue"
       LOCAL_THISRC=${__TRUE}
    else
      LogMsg "Create the file \"${FORCE_SEMAPHOR_FILE}\" before installing this Magisk Module to force the installation"
    fi
  fi

 return ${LOCAL_THISRC}
}

# -----------------------------------------------------------------------------

LogMsg "The current environment for this installation is"

LogMsg "The version of the installed Magisk is \"${MAGISK_VER}\" (${MAGISK_VER_CODE})"

LogInfo "BOOTMODE is \"${BOOTMODE}\" "
LogInfo "MODPATH is \"${MODPATH}\" "
LogInfo "TMPDIR is \"${TMPDIR}\" "
LogInfo "ZIPFILE is \"${ZIPFILE}\" "
LogInfo "ARCH is \"${ARCH}\" "
LogInfo "IS64BIT is \"${IS64BIT}\" "
LogInfo "API is \"${API}\" "

# -----------------------------------------------------------------------------

# example output for the variables:


#  The version of the installed Magisk is "25.0" (25000)
#  INFO: BOOTMODE is "true" 
#  INFO: MODPATH is "/data/adb/modules_update/PlayStore_for_MicroG" 
#  INFO: TMPDIR is "/dev/tmp" 
#  INFO: ZIPFILE is "/data/user/0/com.topjohnwu.magisk/cache/flash/install.zip" 
#  INFO: ARCH is "arm64" 
#  INFO: IS64BIT is "true" 
#  INFO: API is "32"


# -----------------------------------------------------------------------------

LogMsg "Installing the Magisk Module with the binaries from the Android SDK  \"${MODULE_VERSION}\" ..."
LogMsg ""
LogMsg "This module contains the Android SDK binaries from this URL https://github.com/lzhiyong/android-sdk-tools/releases/download/34.0.3/android-sdk-tools-static-aarch64.zip"
LogMsg ""

# LogMsg "Checking the OS configuration ..."

ERRORS_FOUND=${__FALSE}

MACHINE_TYPE="$( uname -m )"

# check the current CPU
#
LogMsg "Checking the type of the CPU used in this device ...."
LogMsg "The CPU in this device is a ${ARCH} CPU"
LogMsg "The machine type reported by \"uname -m\" is \"${MACHINE_TYPE}\" "

if [ ${ARCH}x != "arm64"x ] ; then
  echo "ERROR: This Magisk Module ist for ARM64 CPUs only"
  ERRORS_FOUND=${__TRUE}
fi

if [ ${ERRORS_FOUND} = ${__TRUE} ] ; then
  check_for_force_semaphor || abort "ERRROR: One or more errors in the prerequisite checks found"
fi

exit 0

