# 
# Magisk init script service.sh for the Magisk Module to disable the AFWall firewall
# 
# History
#   24.01.2026 /bs
#     initial release
#
# use the command
#
#   resetprop -w sys.boot_completed 0
#
# to wait until the boot is complete
#
# Note: Do NOT use typeset in this script!
#
# -----------------------------------------------------------------------------
# define some constants
#
__TRUE=0
__FALSE=1

#
# -----------------------------------------------------------------------------
#
# the environment variable MODPATH is only defined by Magisk for the script customize.sh
#
[ "${MODPATH}"x = ""x ] && MODPATH="${0%/*}"

MODULE_NAME="$( grep "^id=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"
[ "${MODULE_NAME}"x = ""x ] && MODULE_NAME="unknown_magisk_module"

MODULE_VERSION="$( grep "^version=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"

MODULE_DESC="${MODULE_NAME} ${MODULE_VERSION}"

# customize.sh is sourced in
# #
[ "$0"x = "sh"x ] && SCRIPT_NAME="customize.sh" || SCRIPT_NAME="${0##*/}"

# -----------------------------------------------------------------------------
#
# avoid duplicate executions
#
mkdir /dev/${MODULE_NAME} || exit 

# ----------------------------------------------------------------------------
#
# LogDebugMsg - print a Message if DEBUG_MODE is ${__TRUE}
# 
# Usage: LogDebugMsg [message]
#
function LogDebugMsg {
	if [ ${DEBUG_MODE} = ${__TRUE} ] ; then
		echo "$*"
	fi
}

# -----------------------------------------------------------------------------
# change either "0 = 1" to "0 = 0" in this script or create the file /data/local/tmp/debug to enable the debug output to the log file
#

if [ 0 = 1 -o -r /data/local/tmp/debug ] ; then
  LOGFILE="/data/local/tmp/${MODULE_NAME}_${SCRIPT_NAME}.log"

#  echo "Writing all messages to the log file ${LOGFILE}"

   exec 1>"${LOGFILE}" 2>&1

   echo "The PID of this process is $$"

   if [ -r /data/local/tmp/trace ] ; then
     set -x
     TRACE_MODE=${__TRUE}
   else
      TRACE_MODE=${__FALSE}    
   fi

   DEBUG_MODE=${__TRUE}   
else
  DEBUG_MODE=${__FALSE}     
  TRACE_MODE=${__FALSE}  
 fi

# -----


# echo "This is the script $0 for the module \"${MODULE_NAME}\" "

# wait until the boot is complete:
#
# resetprop -w sys.boot_completed 0.
#
#
WAIT_TIME=60

FW_DISABLED=${__FALSE}

echo "Disabling the AFwall firewall ..."

date

echo "Waiting up to ${WAIT_TIME} seconds until AFWall configured the firewall ..."


i=0
while [ $i -lt ${WAIT_TIME} ] ; do
	echo "Checking the active iptable rules ..."
	echo
	iptables -S | grep -- "-A OUTPUT -j afwall"
	if [ $? -eq 0 ] ; then

		echo "The AFWall firewall is configured after $i seconds ..."
		sleep 2

		echo "Now disabling the AFwall firewall ..."
		iptables -D OUTPUT -j afwall
		FW_DISABLED=${__TRUE}
		break
	fi
	let i=i+1 
	sleep 1
done

if [ ${FW_DISABLED} != ${__TRUE} ] ; then
	echo "Could not find a configured AWFirewall"
fi

\rmdir /dev/${MODULE_NAME}


