# 
# Magisk script action.sh for the Magisk Module to disable the AFWall firewall
#
# Note: All messages written to STDOUT are displayed in the Magisk output window 
#
# History
#  24.01.2026 /bs
#     initial release
#     
# Note: Do NOT use typeset in this script!
#
# -----------------------------------------------------------------------------
# define some constants
#
__TRUE=0
__FALSE=1

export IN_ACTION__SCRIPT=${__TRUE}

# -----------------------------------------------------------------------------
#
# the environment variable MODPATH is only defined by Magisk for the script customize.sh
#
[ "${MODPATH}"x = ""x ] && MODPATH="${0%/*}"

MODULE_NAME="$( grep "^id=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"
[ "${MODULE_NAME}"x = ""x ] && MODULE_NAME="unknown_magisk_module"

MODULE_VERSION="$( grep "^version=" ${MODPATH}/module.prop  | cut -f2 -d "=" )"

MODULE_DESC="${MODULE_NAME} ${MODULE_VERSION}"

# customize.sh is sourced in
# #
[ "$0"x = "sh"x ] && SCRIPT_NAME="customize.sh" || SCRIPT_NAME="${0##*/}"


# -----------------------------------------------------------------------------
# save the file handle for STDOUT to file handle 5 ( &5 is used in the function printMsg )
#
exec 5>&1

# ----------------------------------------------------------------------------
#
# printMsg - print a Message to the Magisk output window even if redirection of STDOUT to the logfile is enabled
# 
# Usage: printMsg [message]
#
function printMsg {
   echo "$*" >&5
}

# ----------------------------------------------------------------------------
#
# LogDebugMsg - print a Message if DEBUG_MODE is ${__TRUE}
# 
# Usage: LogDebugMsg [message]
#
function LogDebugMsg {
  if [ ${DEBUG_MODE} = ${__TRUE} ] ; then
    echo "$*"
  fi
}

# ---------------------------------------------------------------------
# ReadVolumeKeys - read the status of the volume keys
#
# Usage: ReadVolumeKeys [timeout] 
#
# Parameter:
#        timeout - timeout in seconds to wait; the default value is 10 seconds
#
# returns:
#        0 - no volume key pressed 
#        1 - volume up pressed
#        2 - volume down pressed
#
function ReadVolumeKeys {
  typeset __FUNCTION="ReadVolumeKeys"

  typeset THISRC=0
   
  typeset DEFAULT_TIMEOUT=10
  
  typeset TIMEOUT="${DEFAULT_TIMEOUT}"
  typeset MESSAGE=""
  
  typeset dev=""
  typeset type=""
  typeset code=""
  typeset value=""
  
  typeset RESULT=""

  if [ $# -eq 1 ] ; then
    TIMEOUT=$1
    shift
  fi

# the variables dev, type, code, and value can not be used here because the "while" statement is running a separate session
#
  RESULT=$( timeout ${TIMEOUT} getevent -ql | while read dev type code value; do
    if [ "$code" = "KEY_VOLUMEUP" ] && [ "$value" = "DOWN" ]; then
      echo 1
      break
    elif [ "$code" = "KEY_VOLUMEDOWN" ] && [ "$value" = "DOWN" ]; then
      echo 2
      break
    fi
  done )
   
  [ "${RESULT}"x != ""x ] && THISRC="${RESULT}"
  
  return ${THISRC}
}

# -----------------------------------------------------------------------------
# change either "0 = 1" to "0 = 0" in this script or create the file /data/local/tmp/debug to enable the debug output to the log file
#
if [ 0 = 1  -o -r /data/local/tmp/debug ] ; then
  LOGFILE="/data/local/tmp/${MODULE_NAME}_${SCRIPT_NAME}.log"

  printMsg  "----"
  printMsg  "Messages to STDOUT are now redirected to the log file 
  ${LOGFILE}"
  printMsg  "----"

  exec 1>"${LOGFILE}" 2>&1
  
  if [ -r /data/local/tmp/trace ] ; then
    set -x
    TRACE_MODE=${__TRUE}
  else
    TRACE_MODE=${__FALSE}    
  fi

  DEBUG_MODE=${__TRUE}   
else
  DEBUG_MODE=${__FALSE}     
  TRACE_MODE=${__FALSE}
fi

# ----------------------------------------------------------------------------

# printMsg "This message goes to the Magisk Output Window 
# even if STDOUT is redirected to a file"

# echo "This message goes to the Magisk Output 
# window if STDOUT is NOT redirected;
# it goes to the logfile if STDOUT is redirected to a file"

# echo "This messages goes to the log file if STDERR 
# is redirected to a file. It goes to the Nirvana if STDERR 
# is NOT redirected" >&2


echo "Checking if the iptables rule for afwall is enabled ..."
iptables -S | grep -- "-A OUTPUT -j afwall"
if [ $? -eq 0 ] ; then
  echo "The iptables rule for afwall is enabled "
  echo "Now disabling the iptables rule for afwall ..."
  iptables -D OUTPUT -j afwall
  echo
  echo "Press the Action button again to enable "
  echo "the iptable rule for afwall again"
else
  echo "The iptables rule for afwall is not enabled"
  echo "Now enabling the iptables rule for afwall ..."
  iptables -A OUTPUT -j afwall
  echo
  echo "Press the Action button again to disable "
  echo "the iptable rule for afwall again"
fi 

